using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
 using PsgBase;
using System.Globalization;
using PsgIntl;

namespace Orders
{
    [EditorClass, ViewGrid]
    public partial class Orders : BaseDetails
    {
        #region Members

        OrdersBE.OrdersDataTable table = new OrdersBE.OrdersDataTable();
        OrdersBE.OrdersRow rowA = null;

        DataTable dtProducts = null;

        #endregion

        #region Constructors

        public Orders()
        {
            InitializeComponent();
        }

        public Orders(ViewGrid _browser):base(_browser)
        {
            InitializeComponent();
            gridDetails.AutoGenerateColumns = false;
        }

        public Orders(LookupGrid _search):base(_search)
        {
            InitializeComponent();
        }

        #endregion Constructors

        #region Base

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "orderid";
            context.PsgFieldDisplay = "customer";
            context.PsgCommand = "orders";
            context.PsgServerTableName = "orders";
            context.PsgColumnSort = "orderdate";
            context.PsgSortOrder = SortOrder.Descending;
        }

        public override void PsgStart()
        {
            base.PsgStart();

            this.getdata.AddTable("orders", ID, "C");
            this.getdata.AddTable("employees", "null", "C");
            this.getdata.AddTable("customers", "null", "C");
            this.getdata.AddTable("shippers", "null", "C");
            this.getdata.AddTable("products", "null", "C");
            this.getdata.AddTable("orderdetails", ID, "C");
            this.getdata.GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "CUSTOMERS":
                    cbCustomer.PsgComboTable = this.Intf.PsgTableServer;
                    cbCustomer.DataSource = cbCustomer.PsgComboTable;
                    cbCustomer.DisplayMember = "companyname";
                    cbCustomer.ValueMember = "customerid";
                    break;
                case "EMPLOYEES":
                    cbEmployee.PsgComboTable = this.Intf.PsgTableServer;
                    cbEmployee.DataSource = cbEmployee.PsgComboTable;
                    cbEmployee.DisplayMember = "lastname";
                    cbEmployee.ValueMember = "employeeid";
                    break;
                case "SHIPPERS":
                    cbShipper.PsgComboTable = this.Intf.PsgTableServer;
                    cbShipper.DataSource = cbShipper.PsgComboTable;
                    cbShipper.DisplayMember = "companyname";
                    cbShipper.ValueMember = "shipperid";
                    break;
                case "ORDERDETAILS":
                    gridDetails.DataSource = this.Intf.PsgTableServer;
                    tableDServer = this.Intf.PsgTableServer;
                    break;
                case "PRODUCTS":
                    dtProducts = this.Intf.PsgTableServer;
                    productid.DataSource = dtProducts;
                    productid.DisplayMember = "productname";
                    productid.ValueMember = "productid";
                    break;
                case "ORDERS":
                    table = (OrdersBE.OrdersDataTable)SetMainData(dt, table);
                    rowA = (OrdersBE.OrdersRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindCombo(cbCustomer, table.CustomerColumn, table.CustomerIDColumn);
            BindCombo(cbEmployee, table.EmployeeColumn, table.EmployeeIDColumn);
            BindCombo(cbShipper, table.ShipperColumn, table.ShipperIDColumn);
            BindEdit(edFreight, table.FreightColumn);
            BindEdit(edShipName, table.ShipNameColumn);
            BindEdit(edShipAddress, table.ShipAddressColumn);
            BindEdit(edShipCity, table.ShipCityColumn);
            BindEdit(edShipRegion, table.ShipRegionColumn);
            BindEdit(edShipPostalCode, table.ShipPostalCodeColumn);
            BindEdit(edShipCountry, table.ShipCountryColumn);
            BindData(dtOrderDate, table.OrderDateColumn);
            BindData(dtRequireDate, table.RequireDateColumn);
            BindData(dtShippedDate, table.ShippedDateColumn);

            base.PsgBind();

            gridDetails.CellValueChanged += new DataGridViewCellEventHandler(gridDetails_CellValueChanged);
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.CustomerColumn, GetIntl(Intl.Customer), 150);
            this.ColumnsView(table.EmployeeColumn, GetIntl(Intl.Employee), 150);
            this.ColumnsView(table.OrderDateColumn, GetIntl(Intl.Order_date));
            //this.ColumnsView(table.RequireDateColumn, "");
            this.ColumnsView(table.ShippedDateColumn, GetIntl(Intl.Ship_date));
            //this.ColumnsView(table.FreightColumn, GetIntl(Intl.Freight), FilterType.Min);
            this.ColumnsView(table.FreightColumn, GetIntl(Intl.Freight));
            // this.ColumnsView(table.ShipNameColumn, GetIntl(Constants.Ship_name));
            this.ColumnsView(table.ShipAddressColumn, GetIntl(Intl.Ship_address), 250);
            //this.ColumnsView(table.ShipCityColumn, GetIntl(Constants.Ship_city));
            //this.ColumnsView(table.ShipRegionColumn, GetIntl(Constants.Ship_region));
            //this.ColumnsView(table.ShipPostalCodeColumn, GetIntl(Constants.Ship_postal_code));
            //this.ColumnsView(table.ShipCountryColumn, GetIntl(Constants.Ship_country));

            this.FiltersView(table.EmployeeColumn, GetIntl(Intl.Employee)); this.ColumnsView(table.FreightColumn, GetIntl(Intl.Freight), FilterType.Min);
            this.FiltersView(table.OrderDateColumn, GetIntl(Intl.Order_date));
            //this.FiltersView(table.RequiredDateColumn, GetIntl(Constants.Required_date));
            this.FiltersView(table.ShippedDateColumn, GetIntl(Intl.Ship_date));
            this.FiltersView(table.FreightColumn, GetIntl(Intl.Freight), "", FilterType.Min);
            this.FiltersView(table.FreightColumn, GetIntl(Intl.Freight), "", FilterType.Max);
            //this.FiltersView(table.ShipNameColumn, GetIntl(Constants.Ship_name));
            this.FiltersView(table.ShipAddressColumn, GetIntl(Intl.Ship_address));
            //this.FiltersView(table.ShipCityColumn, GetIntl(Constants.Ship_city));
            //this.FiltersView(table.ShipRegionColumn, GetIntl(Constants.Ship_region));
            //this.FiltersView(table.ShipPostalCodeColumn, GetIntl(Constants.Ship_postal_code));
            //this.FiltersView(table.ShipCountryColumn, GetIntl(Constants.Ship_country));
        }

        #endregion

        #region Events

        void gridDetails_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0 || e.ColumnIndex < 0)
                return;

            if (gridDetails.CurrentRow == null || gridDetails.CurrentCell == null)
                return;

            if (e.ColumnIndex == gridDetails.Columns[productid.Name].Index)
            {
                if (gridDetails.CurrentRow.Cells[productid.Name].Value == null || gridDetails.CurrentRow.Cells[productid.Name].Value == DBNull.Value)
                    return;

                foreach (DataRow row in dtProducts.Rows)
                    if (Utils.StringEquals(row["productid"], gridDetails.CurrentRow.Cells[productid.Name].Value))
                    {
                        gridDetails.CurrentRow.Cells[unitprice.Name].Value = IsNull(row["unitprice"], 0);

                        Base.psgCommands.Add(psgUpdate(gridDetails.PsgServerTableName, gridDetails.PsgValueKey, gridDetails.PsgFieldKey,
                            gridDetails.CurrentRow.Cells["productid"].Value.ToString(), "productid", "C", true));
                        Base.psgCommands.Add(psgUpdate(gridDetails.PsgServerTableName, gridDetails.PsgValueKey, gridDetails.PsgFieldKey,
                            IsNull(gridDetails.CurrentRow.Cells["unitprice"].Value, "0"), "unitprice", "N", true));
                        this.psgMultiCommand(ref Base.psgCommands);

                        break;
                    }
            }

            RefreshTotalDetalii();
        }

        private void Orders_Load(object sender, EventArgs e)
        {
            RefreshTotalDetalii();
        }

        private void RefreshTotalDetalii()
        {
            double totalDetalii = 0;
            foreach (DataGridViewRow _row in gridDetails.Rows)
                if (!string.IsNullOrEmpty(_row.Cells["unitprice"].Value.ToString()))
                    totalDetalii += Convert.ToDouble(_row.Cells["unitprice"].Value);
            lblDetaliiTotal.Text = totalDetalii.ToString();
        }

        private void gridDetails_RowsRemoved(object sender, DataGridViewRowsRemovedEventArgs e)
        {
            RefreshTotalDetalii();
        }

        private void gridDetails_CurrentCellDirtyStateChanged(object sender, EventArgs e)
        {
            gridDetails.CommitEdit(DataGridViewDataErrorContexts.Formatting);

            if (!gridDetails.Visible)
                return;

            if (gridDetails.CurrentRow == null || gridDetails.CurrentCell == null)
                return;

            gridDetails.initial_value = gridDetails.PsgCurrent_Value = string.Empty;

            if (gridDetails.CurrentCell.ColumnIndex == gridDetails.Columns[productid.Name].Index)
            {
                if (gridDetails.CurrentRow.Cells[productid.Name].Value == null || gridDetails.CurrentRow.Cells[productid.Name].Value == DBNull.Value)
                    return;

                foreach (DataRow row in dtProducts.Rows)
                    if (Utils.StringEquals(row["productid"], gridDetails.CurrentRow.Cells[productid.Name].Value))
                    {
                        gridDetails.CurrentRow.Cells[unitprice.Name].Value = IsNull(row["unitprice"], 0);

                        break;
                    }
            }
        }

        #endregion
    }
}